%compute the steady state of NK Model 

function [ys,params,check]=NK_financial_steadystate(~,~,M_,~)
global M_
%% DO NOT CHANGE THIS PART.
%%
%% Here we load the values of the deep parameters in a loop.
%%
check = 0;
NumberOfParameters = M_.param_nbr;                            % Number of deep parameters.
% for i = 1:NumberOfParameters                                  % Loop...
%   paramname = cell2mat(deblank(M_.param_names(i,:)));         %    Get the name of parameter i. 
%   eval([ paramname ' = M_.params(' int2str(i) ');']);         %    Get the value of parameter i.
% end                                                           % End of the loop.  
gy = M_.params(1);
alp = M_.params(2);
delta = M_.params(3);
zzetap = M_.params(4);
zzetaw = M_.params(5);
sigma_c = M_.params(6);
chi = M_.params(7);
phiX = M_.params(8);
xip = M_.params(9);
xiw = M_.params(10);
gammap = M_.params(11);
gammaw = M_.params(12);
PIE_bar = M_.params(13);
g_bar = M_.params(14);
Rn_bar = M_.params(15);
rho_r = M_.params(16);
theta_pie = M_.params(17);
theta_y = M_.params(18);
theta_dy = M_.params(19);
rhoA = M_.params(20);
rhoG = M_.params(21);
rhoMCS = M_.params(22);
rhoMRSS = M_.params(23);
rhoMPS = M_.params(24);
rhoRPS = M_.params(25);
rhoIS = M_.params(26);
sigma_s = M_.params(27);
wr = M_.params(28);
apsi = M_.params(29);
%%

%% THIS BLOCK IS MODEL SPECIFIC.
%%
%% Here the user has to define the steady state.
%%

H0      = 0.5;
x0      = log(H0);
options = optimset('TolFun',1e-9,'TolX',1e-9,'MaxIter', 5000, 'MaxFunEvals', 5000, 'Display','off');
x       = fsolve(@ss_fun_NK,x0,options);

H       = exp(x(1));

g       = g_bar/100;
betta   = (PIE_bar/100+1)/(Rn_bar/100+1)/(1+g)^(-sigma_c); % (273)

A       = 1;
MCS     = 1;
MRSS    = 1;
IS      = 1;
MPS     = 1;
RPS     = 1;

PIE     = PIE_bar/100+1;

S       = 0; % (228)
Sdash   = 0; % (229)
PIEw    = (1+g)*PIE; % (230)
Q       = 1; % (231)
LAMBDA  = betta*(1+g)^(-sigma_c); % (232)
rK      = 1/LAMBDA-(1-delta); % (233)
PO      = ((1-xip*PIE^((gammap-1)*(1-zzetap)))/(1-xip))^(1/(1-zzetap)); % (234)
Deltap  = (1-xip)/(1-xip*PIE^(zzetap*(1-gammap)))*PO^(-zzetap); % (235)
MC      = (1-1/zzetap)*1/MCS*(1-xip*(1+g)*LAMBDA*PIE^(zzetap*(1-gammap)))/(1-xip*(1+g)*LAMBDA*PIE^((zzetap-1)*(1-gammap)))*PO; % (236)
PWP     = MC; % (237)
WO      = ((1-xiw*PIE^(gammaw*(1-zzetaw))*PIEw^(zzetaw-1))/(1-xiw))^(1/(1-zzetaw)); % (238)

Deltaw  = (1-xiw)/(1-xiw*PIEw^(zzetaw)/PIE^(gammaw*zzetaw))*WO^(-zzetaw); % (239)
Hd      = H/Deltaw; % (240)
KYW     = (1-alp)*(1+g)/(rK)*PWP; % (241)
YW      = A*Hd*(KYW/(1+g))^((1-alp)/alp); % (242)
K       = YW*KYW; % (243)
Y       = YW/Deltap; % (244)
I       = K/IS*(g+delta)/(1+g); % (245)
G       = gy*Y; % (246)
C       = Y-G-I; % (247)
JJw     = Hd/(1-xiw*LAMBDA*PIEw^zzetaw*PIE^(gammaw*(1-zzetaw)-1)); % (248)
W       = alp*PWP*YW/Hd; % (249)
Jw      = WO*W*JJw; % (250)
Wh      = (1-xiw*(1+g)*LAMBDA*PIEw^zzetaw/PIE^(gammaw*zzetaw))*(1-1/zzetaw)*Jw/(Hd*MRSS); % (251)
U       = (C*(1-chi/(1+g)))^(1-sigma_c)/(1-sigma_c)*exp((sigma_c-1)*H^(1+apsi)/(1+apsi)); % (252)

V       = U/(1-betta*(1+g)^(1-sigma_c)); % (254)
Vmodified = V; % (254a)
X       = 1+g; % (255)
lambda  = (1-sigma_c)*U/(C-chi*C/(1+g))-betta*chi*(1-sigma_c)*U/(1+g)^(1-sigma_c)/((1+g)*C-chi*C); % (256)
R       = 1/LAMBDA; % (257)
Rn      = R*PIE; % (258)
Jp      = Y*MC*MCS/((1-1/zzetap)*(1-xip*(1+g)*LAMBDA*PIE^(zzetap*(1-gammap)))); % (259);
JJp     = Jp/PO; % (260)
RK      = rK+(1-delta); % (261)
spread  = RK-R; % (262)
CEquiv  = (1.01^(1-sigma_c)-1)*U/(1-betta*(1+g)^(1-sigma_c)); % (263)
UH      = -(1-sigma_c)*U*H^apsi;

dyobs   = log((1+g));
dcobs   = log((1+g));
dinvobs = log((1+g));
dwobs   = log((1+g));
labobs  = 0;
robs    = (Rn-1);
pinfobs = (log(PIE));
spreadobs = 0;


%% END OF THE MODEL SPECIFIC BLOCK.

%% DO NOT CHANGE THIS PART.
%%
%% Here we define the steady state vZNues of the endogenous variables of
%% the model.
%%
NumberOfEndogenousVariables = M_.endo_nbr;                    % Number of endogenous variables.
ys = zeros(NumberOfEndogenousVariables,1);                    % Initialization of ys (steady state).
% for ii = 1:NumberOfEndogenousVariables                        % Loop...
%     varname = cell2mat(deblank(M_.endo_names(ii,:)));         %    Get the name of endogenous variable i.         
%     eval([ 'ys(' num2str(ii) ') = ' varname ';' ]);           %    Get the steady state vZNue of this variable.    
% end                                                           % End of the loop.
ys(1) = V;
ys(2) = Vmodified;
ys(3) = U;
ys(4) = C;
ys(5) = H;
ys(6) = K;
ys(7) = S;
ys(8) = X;
ys(9) = I;
ys(10) = IS;
ys(11) = Sdash;
ys(12) = lambda;
ys(13) = Wh;
ys(14) = rK;
ys(15) = RPS;
ys(16) = R;
ys(17) = Q;
ys(18) = Rn;
ys(19) = PIE;
ys(20) = PIEw;
ys(21) = W;
ys(22) = Jw;
ys(23) = Hd;
ys(24) = MRSS;
ys(25) = JJw;
ys(26) = WO;
ys(27) = Deltaw;
ys(28) = YW;
ys(29) = A;
ys(30) = PWP;
ys(31) = MC;
ys(32) = Jp;
ys(33) = Y;
ys(34) = MCS;
ys(35) = JJp;
ys(36) = PO;
ys(37) = Deltap;
ys(38) = MPS;
ys(39) = G;
ys(40) = RK;
ys(41) = spread;
ys(42) = CEquiv;
ys(43) = dyobs;
ys(44) = dcobs;
ys(45) = pinfobs;
ys(46) = robs;
ys(47) = labobs;
ys(48) = spreadobs;
ys(49) = dinvobs;
ys(50) = dwobs;
ys(51) = UH;

% Update parameters set in the file
params=NaN(NumberOfParameters,1);
% for iter = 1:length(M_.params)-1  
%     eval([ 'params(' num2str(iter) ') = ' M_.param_names{iter} ';' ])
% end                                                 
% params(29) = apsi;

params(1) = M_.params(1);
params(2) = M_.params(2);
params(3) = M_.params(3);
params(4) = M_.params(4);
params(5) = M_.params(5);
params(6) = M_.params(6);
params(7) = M_.params(7);
params(8) = M_.params(8);
params(9) = M_.params(9);
params(10) = M_.params(10);
params(11) = M_.params(11);
params(12) = M_.params(12);
params(13) = M_.params(13);
params(14) = M_.params(14);
params(15) = M_.params(15);
params(16) = M_.params(16);
params(17) = M_.params(17);
params(18) = M_.params(18);
params(19) = M_.params(19);
params(20) = M_.params(20);
params(21) = M_.params(21);
params(22) = M_.params(22);
params(23) = M_.params(23);
params(24) = M_.params(24);
params(25) = M_.params(25);
params(26) = M_.params(26);
params(27) = M_.params(27);
params(28) = M_.params(28);
params(29) = M_.params(29);

